<?php


require_once "../config/db.php";
require_once "../config/BD.php";
require_once "../appis/fpdf.php";


class InicialModels
{
    public function __construct(){
        $this->bd = BD::obtener();
    }


    public function get_traer_Proveedores()
    {
        
        
        $sentencia = $this->bd->prepare("select id,nombre,username from user where user_role=3 and estatus='A'");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public function get_traer_deptos()
    {
        
        
        $sentencia = $this->bd->prepare("select id,depto from deptos where estatus='A'");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public function get_traer_obras()
    {
        
        
        $sentencia = $this->bd->prepare("select id,obra from cat_obras where estatus='A'");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public function traer_Folios()
    {
        
        $sentencia = $this->bd->prepare("select id from odc ORDER BY id DESC limit 1;");
        $sentencia->execute();
        return $sentencia->fetch(PDO::FETCH_OBJ);
    }


    public function clean( $string, $divider='', $camelcase=false ) {
        // Remove special characters

        $string = preg_replace('([^A-Za-z0-9\._\-@])', '', $string);

        // Remove whitespace
        $string = trim( $string );

        // Make lowercase
        $string = strtolower( $string );

        if( !$camelcase ) {
            // Replace spaces with the divider
            $string = preg_replace('([^A-Za-z0-9\._\-@])', $divider, $string);
        } else {
            // Make all the words uppercase
            $string = ucwords( $string );

            // Remove spaces and special characters
            $string = preg_replace( '/[^A-Za-z0-9]/', '', $string );

            // Lowercase the first word
            $string = lcfirst( $string );
        }

        return $string;
    }


    public function get_save_oc($idUsuario,$rfc_pro,$id_prov,$fobra,$obra,$importe,$files,$noc,$numnoc,$depto)
    { 

        $rutaevidencia="";
        $sentencia = $this->bd->prepare("insert into odc (OC, rfc, iduser, fobra, obra, importe, ruta_oc, factura, xml, evidencia, contrarecibo, pago, comppago, user_crea,estatus, user_modif,comentario,depto,completa,id_odc,liquidado,fecha_crea,fecha_fin)
            values (?, ?, ?, ?, ?,?,?,?,?,?, ?, ?, ?, ?,?,?,?,?,?,?,?,NOW(),NOW());");

        $sentencia->execute([$numnoc,$rfc_pro,$id_prov,$fobra,$obra,$importe,$rutaevidencia,'N','N','N','N','N','N',$idUsuario,'1',$idUsuario,'',$depto,'','','1']);

        if($sentencia){
            $idUltimo=$this->bd->lastInsertId();

            if($files['name']){

                $filename = $this->clean($files['name']);
                
                /*$path = "../documentos/".$numnoc."/".$fobra."/".$rfc_pro."/OC";
                $path2 = "/documentos/".$numnoc."/".$fobra."/".$rfc_pro."/OC";*/

                $path = "../documentos/".$idUltimo."/".$numnoc."/".$rfc_pro."/OC";
                $path2 = "/documentos/".$idUltimo."/".$numnoc."/".$rfc_pro."/OC";

                if(!file_exists($path)){
                   //crear directorio
                   mkdir($path,0777,true);

                   

                }else{
                   

                   if (move_uploaded_file($files['tmp_name'], $path."/".$filename)) {
                        $banguardo=true;
                        $rutaevidencia=$path2."/".$filename;  
                        
                    }
                }

                if (move_uploaded_file($files['tmp_name'], $path."/".$filename)) {
                        $banguardo=true;
                        $rutaevidencia=$path2."/".$filename;  
                      

                }

            }else{
                $rutaevidencia="";
            }

            $sentenciaruta = $this->bd->prepare("update odc set ruta_oc = ? where id=?;");
            $sentenciaruta->execute([$rutaevidencia,$idUltimo]);
        }


        return $sentencia;
            
    }
    
    public  function get_ordenes_inicial($idusuario,$userrol,$search,$num_oc,$estatusoc)
    {

        if($estatusoc){
            $filtrostatus=" where o.estatus='".$estatusoc."'";
        }else{
            $filtrostatus=" where o.estatus in (1,2,3,4,5)";
        }

        if($userrol=='1' || $userrol=='2'){
                $whereand="";
        }else{
            $whereand=" and iduser=".$idusuario;
        }

        if($search){
            $filtrorfc=" AND o.rfc='".$search."'";
        }else{
            $filtrorfc="";
        }

        if($num_oc){
            $filtroOC=" AND o.OC='".$num_oc."'";
        }else{
            $filtroOC="";
        }

        

        $sentencia = $this->bd->prepare("select o.id,o.OC,o.rfc,o.iduser,o.fobra,o.obra,o.importe,o.ruta_oc,o.factura,o.xml,o.evidencia,o.contrarecibo,o.pago,o.comppago,o.estatus, DATE_FORMAT(o.fecha_crea, '%d-%m-%Y') AS fecha_crea ,u.nombre, u.user_role, (
                        SELECT DISTINCT(c.folio_cr) 
                        FROM crecibo_xml c 
                        WHERE c.user_xml = o.iduser and c.id_odc=o.OC GROUP by c.id_odc
                    ) AS folio_crecibo, (SELECT DISTINCT(c.f_pago) 
                            FROM crecibo_xml c 
                            WHERE c.user_xml = o.iduser and c.id_odc=o.OC GROUP by c.id_odc
                        ) AS facha_pago,o.comentario,o.liquidado from odc o left join user u on o.iduser=u.id  $filtrostatus $whereand $filtrorfc $filtroOC order by o.OC desc,o.id desc;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public function get_traer_Proveedores_tipo($tipo_user)
    {
        
        
        $sentencia = $this->bd->prepare("select * from user where user_role='".$tipo_user."'");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public function get_save_archivos($idUsuario,$rfc_pro,$fobra,$tipodoc,$odc,$files,$nombrearchi,$id,$fpgo)
    { 
        /*$path = "../documentos/".$odc."/".$fobra."/".$rfc_pro."/".$nombrearchi;
        $path3 = "/documentos/".$odc."/".$fobra."/".$rfc_pro."/".$nombrearchi;*/

        $path = "../documentos/".$id."/".$odc."/".$rfc_pro."/".$nombrearchi;
        $path3 = "/documentos/".$id."/".$odc."/".$rfc_pro."/".$nombrearchi;

        

        foreach ($files['name'] as $key => $name) {
            
            $targetFile = $path."/".basename($name);

            if(!file_exists($path)){
               //crear directorio
               mkdir($path,0777,true);

               


            }else{
               
               
               if (move_uploaded_file($files['tmp_name'][$key], $targetFile)) {
                    $banguardo=true;
                    $rutaevidencia=$path3."/".$name;  
                    
                }
            }

            if (move_uploaded_file($files['tmp_name'][$key], $targetFile)) {
                    $banguardo=true;
                    $rutaevidencia=$path3."/".$name;  
                   
            }

            

             $sentenciadoc = $this->bd->prepare("insert into rutas_arch (idorden,id_oc,id_contr, rutas, tipo_arch,posicion, usua_crea,fecha_pago,fecha_crea)
            values (?, ?, ?,?,?,?,?,?,NOW());");

             $sentenciadoc->execute([$id,$odc,'',$rutaevidencia,$tipodoc,$key,$idUsuario,$fpgo]);

            
         }

         if($sentenciadoc){
            $banderastat=2;

            if($tipodoc=='f'){

                $sentencia = $this->bd->prepare("update odc set factura = ? where id=?;");
                $sentencia->execute(['S',$id]);

                $sentenciasta = $this->bd->prepare("update odc set estatus=? where id=? and xml='S' and evidencia='S';");
                $sentenciasta->execute(['2',$id]);

                if ($sentenciasta->rowCount() > 0) {
                   $banderastat=1;
                }

                
            }

           
            if($tipodoc=='e'){
                $sentencia = $this->bd->prepare("update odc set evidencia = ? where id=?;");
                $sentencia->execute(['S',$id]);

                $sentenciasta = $this->bd->prepare("update odc set estatus=? where id=? and xml='S' and factura='S';");
                $sentenciasta->execute(['2',$id]);

                if ($sentenciasta->rowCount() > 0) {
                   $banderastat=1;
                }
            }
            
            if($tipodoc=='p'){
                $sentencia = $this->bd->prepare("update odc set pago = ?,estatus=? where id=?;");
                $sentencia->execute(['S','4',$id]);
            }
            if($tipodoc=='cp'){
                $sentencia = $this->bd->prepare("update odc set comppago = ?,estatus=? where id=?;");
                $sentencia->execute(['S','5',$id]);
            }

            

          $sentenciadoc=true;

         }

        $resultadoconsulta['estatus']=$sentenciadoc;
        $resultadoconsulta['bandestat']=$banderastat;

        return $resultadoconsulta;
         //return $sentenciadoc;
        
        
            
    }

    public function get_save_archivo_xml($idUsuario,$rfc_pro,$fobra,$tipodoc,$odc,$files,$nombrearchi,$id,$fpgo,$array_xml,$completo,$saldoOC)
    { 
        $path = "../documentos/".$id."/".$odc."/".$rfc_pro."/".$nombrearchi;
        $path3 = "/documentos/".$id."/".$odc."/".$rfc_pro."/".$nombrearchi;

        /*if(!file_exists($path)){
            mkdir($path,0777,true);
        }

        $countfiles = count($files['name']);

        for($index = 0; $index < $countfiles; $index++){
            if (move_uploaded_file($_FILES['files']['tmp_name'][$index], $path."/".$name)) {

            }

        }*/

        foreach ($files['name'] as $key => $name) {

            /*if($tipodoc=='cp'){
                foreach ($uuid_relacion as $uuidrelacion) {
                    $idxmlrel = $uuidrelacion->idDocumento;
                    return $idxmlrel; 
                }
            }*/
                

            $uuid = strtoupper($array_xml[$key]->complemento->UUID);
            $sentenciaexiste = $this->bd->prepare("select UUID from xml where UUID='".$uuid."';");
            $sentenciaexiste->execute();

            if ($sentenciaexiste->rowCount() > 0) {
                $existe=1;
            } else {
                $existe=2;
            }

            if ($existe==2) {
            
                $targetFile = $path."/".basename($name);

                if(!file_exists($path)){
                   //crear directorio
                   mkdir($path,0777,true);

                   


                }else{
                   
                   
                   if (move_uploaded_file($files['tmp_name'][$key], $targetFile)) {
                        $banguardo=true;
                        $rutaevidencia=$path3."/".$name;  
                        
                    }
                }

                if (move_uploaded_file($files['tmp_name'][$key], $targetFile)) {
                        $banguardo=true;
                        $rutaevidencia=$path3."/".$name;  
                       
                }

                

                $sentenciadoc = $this->bd->prepare("insert into rutas_arch (idorden,id_oc,id_contr, rutas, tipo_arch,posicion, usua_crea,fecha_pago,fecha_crea)
                values (?,?, ?, ?,?,?,?,?,NOW());");

                $sentenciadoc->execute([$id,$odc,'',$rutaevidencia,$tipodoc,$key,$idUsuario,$fpgo]);

                if($sentenciadoc){


                    

                    $idUltimo=$this->bd->lastInsertId();

                    $fechaaproxpgo=date('Y-m-d',strtotime($fpgo));

                    $uuid = strtoupper($array_xml[$key]->complemento->UUID);
                    $tipoComprobante = $array_xml[$key]->comprobante->TipoDeComprobante;
                    $total = $array_xml[$key]->comprobante->Total;
                    $fechaEmision = $array_xml[$key]->comprobante->Fecha;
                    $emisor = $array_xml[$key]->emisor->Nombre;
                    $rfc_emisor = $array_xml[$key]->emisor->Rfc;
                    $receptor = $array_xml[$key]->receptor->Nombre;
                    $rfc_receptor = $array_xml[$key]->receptor->Rfc;
                    $monedas = $array_xml[$key]->comprobante->Moneda;

                        

                        
                            

                    $sentenciaxml = $this->bd->prepare("insert into xml (id_arch, id_oc, UUID, rfc_emisor, emisor, rfc_receptor, receptor, f_emision, monto,moneda, tipo_c,posiscion, liquidado, contrarecibo,pagos,id_user_c,fecha_crea)
                        values (?, ?, ?,?,?,?, ?, ?,?,?,?,?,?,?,?,?,NOW());");

                    $sentenciaxml->execute([$idUltimo,$odc,$uuid,$rfc_emisor,$emisor,$rfc_receptor,$receptor,$fechaEmision,$total,$monedas,$tipoComprobante,$key,'1','N','N',$idUsuario]);

                        

                            

                    
                 

                }
            }else{
                $sentenciadoc=false;
            }
         }

        if($sentenciadoc){

            if($tipodoc=='x'){

                $banderastat=2;

                $sentencia = $this->bd->prepare("update odc set xml = ? where id=?;");
                $sentencia->execute(['S',$id]);

                $sentenciasta = $this->bd->prepare("update odc set estatus=? where id=? and factura='S' and evidencia='S';");
                $sentenciasta->execute(['2',$id]);

                if ($sentenciasta->rowCount() > 0) {
                   $banderastat=1;
                }

                

                $sentencia = $this->bd->prepare("update odc set completa = ? where id=?;");
                $sentencia->execute([$completo,$id]);

                if($completo=='S'){

                    $sentenciasaldo = $this->bd->prepare("select OC, rfc, iduser, fobra, obra, ruta_oc, user_crea, user_modif, comentario, depto from odc where id='".$id."';");
                    $sentenciasaldo->execute();

                    while($sr = $sentenciasaldo->fetch(PDO::FETCH_ASSOC)){

                         $OC=$sr['OC'];
                         $rfc=$sr['rfc'];
                         $iduser=$sr['iduser'];
                         $fobra=$sr['fobra'];
                         $obra=$sr['obra'];
                         $ruta_oc=$sr['ruta_oc'];
                         $user_crea=$sr['user_crea'];
                         $user_modif=$sr['user_modif'];
                         $comentario=$sr['comentario'];
                         $depto=$sr['depto'];
                         

                         $sentenciaact = $this->bd->prepare("insert  INTO odc(OC, rfc, iduser, fobra, obra, importe, ruta_oc, factura, xml, evidencia, contrarecibo, pago, comppago, user_crea, estatus, user_modif, comentario, depto, completa, id_odc, fecha_crea, fecha_fin) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())");
                         $sentenciaact->execute([$OC,$rfc,$iduser,$fobra,$obra,$saldoOC,$ruta_oc,'N','N','N','N','N','N',$idUsuario,'1',$user_modif,$comentario,$depto,'',$id]);

                    }

                }

                    
            }

        $sentenciadoc=true;
            
        }

        $resultadoconsulta['estatus']=$sentenciadoc;
        $resultadoconsulta['bandestat']=$banderastat;

         return $resultadoconsulta;
        
        
            
    }

    


    public function get_crea_contrar($idUsuario,$userrol,$arrayxml,$array_id_attr,$array_idUs_attr,$array_idDoc_attr,$fpgo)
    {
        

        $total_digitos = 6;

        $sentenciacr = $this->bd->prepare("insert into crecibo (folio_cr, estatus,user_crea, f_creado) values (?,?,?,NOW());");

        $sentenciacr->execute(['','1',$idUsuario]);

        if($sentenciacr){

            $idUltimo=$this->bd->lastInsertId();

            $folio_contrarec = str_pad($idUltimo, $total_digitos, '0', STR_PAD_LEFT);

            $sentenciaupcr = $this->bd->prepare("update crecibo set folio_cr = ? where id=?;");
            $sentenciaupcr->execute([$folio_contrarec,$idUltimo]);

            foreach ($arrayxml as $indice => $id_xml) {
            //foreach ($arrayabonos as $datacontrarecibo) {

                $sentenciaabonos = $this->bd->prepare("insert into crecibo_xml ( id_xml, idDoc,id_odc, folio_cr, user_xml,idcr, f_pago, fecha_crea) values (?,?,?,?,?,?,?,NOW());");
                    //$sentenciaabonos = $this->bd->prepare("update xml set abono=?,saldo=?, num_cr=?, fpago_cr=?,liquidado=? where id=?;");
                $sentenciaabonos->execute([$id_xml,$array_idDoc_attr[$indice],$array_id_attr[$indice],$folio_contrarec,$array_idUs_attr[$indice],$idUltimo,$fpgo]);
                    
                    if($sentenciaabonos){

                        $sentenciadoc = $this->bd->prepare("update xml set contrarecibo = ? where id=?;");
                        $sentenciadoc->execute(['S',$id_xml]);

                        $sentenciadoc = $this->bd->prepare("update odc set contrarecibo = ?,estatus=? where OC=? and iduser=? and xml='S';");
                        $sentenciadoc->execute(['S','3',$array_id_attr[$indice],$array_idUs_attr[$indice]]);
                        
                        
                    }
                   

                
            }

        }else{
                $sentenciacr=false;
        }

        return $sentenciacr;

    }


    public function get_pagos_contrar($idUsuario,$userrol,$fcontra,$fcontexml,$foliocontra,$arrayabonos,$files,$rfc_user)
    {

        $total_digitos = 3;
        $nombrearchi="recibopago";

        $sentenciacr = $this->bd->prepare("insert into pagos (folio, estatus, user_crea,contrarecibo,f_creado) values (?,?,?,?,NOW());");

        $sentenciacr->execute(['','1',$idUsuario,'N']);

        if($sentenciacr){

            $idUltimo=$this->bd->lastInsertId();

            $folio_pagos = str_pad($idUltimo, $total_digitos, '0', STR_PAD_LEFT);

            $sentenciaupcr = $this->bd->prepare("update pagos set folio = ? where id=?;");
            $sentenciaupcr->execute([$folio_pagos,$idUltimo]);

                foreach ($arrayabonos as $datacontrarecibo) {

                    $idxml = $datacontrarecibo->idxml;
                    $id_oc = $datacontrarecibo->id_oc;
                    $oc = $datacontrarecibo->oc;

                        if($datacontrarecibo->abonoxml!=0.00){


                            $base_path = "../documentos/".$id_oc."/".$oc."/".$rfc_user;
                            $base_path3 = "/documentos/".$id_oc."/".$oc."/".$rfc_user;    

                            //$path = "../documentos/".$id_oc."/".$oc."/".$rfc_user."/recibopago";
                            //$path3 = "/documentos/".$id_oc."/".$oc."/".$rfc_user."/recibopago";

                            

                            foreach ($files['name'] as $key => $name) {

                                $targetFileName = basename($name); 
                                
                                //$targetFile = $path."/".basename($name);

                                $rutas_destino = [
                                        $base_path."/".$nombrearchi
                                ];

                                foreach ($rutas_destino as $ruta) {

                                    $targetFile = $ruta."/".$targetFileName; 

                                    if(!file_exists($ruta)){
                                               //crear directorio
                                        mkdir($ruta,0777,true);

                                    }


                                    if (move_uploaded_file($files['tmp_name'][$key], $targetFile)) {
                                        $banguardo=true;
                                        $rutaevidencia=$base_path3."/".$nombrearchi."/".basename($targetFileName);  
                                        $ruta1=$targetFile;
                                    }else{
                                        copy($ruta1, $targetFile);
                                        $rutaevidencia=$base_path3."/".$nombrearchi."/".basename($targetFileName);  
                                    }


                                    $sentenciadoc = $this->bd->prepare("insert into rutas_arch (idorden,id_oc,id_contr,rutas, tipo_arch,posicion,usua_crea,fecha_pago,fecha_crea)
                                values (?, ?, ?,?,?,?,?,?,NOW());");

                                    $sentenciadoc->execute([$id_oc,$oc,$fcontexml,$rutaevidencia,'p',$key,$idUsuario,'0000-00-00']);

                                }    

                                /*if(!file_exists($path)){
                                   //crear directorio
                                   mkdir($path,0777,true);

                                   


                                }else{
                                   
                                   
                                   if (move_uploaded_file($files['tmp_name'][$key], $targetFile)) {
                                        $banguardo=true;
                                        $rutaevidencia=$path3."/".$name;  
                                        
                                    }
                                }

                                if (move_uploaded_file($files['tmp_name'][$key], $targetFile)) {
                                        $banguardo=true;
                                        $rutaevidencia=$path3."/".$name;  
                                       
                                }

                                

                                 $sentenciadoc = $this->bd->prepare("insert into rutas_arch (idorden,id_oc,id_contr, rutas, tipo_arch,posicion, usua_crea,fecha_pago,fecha_crea)
                                values (?, ?, ?,?,?,?,?,?,NOW());");

                                 $sentenciadoc->execute([$id_oc,$oc,$fcontexml,$rutaevidencia,'p',$key,$idUsuario,'0000-00-00']);*/

                                
                             }
                            
                            if($datacontrarecibo->saldoxml==0.00){
                                $liqquidado=2;
                            }else{
                                $liqquidado=1;
                            }

                            $abonoxml = str_replace(",", "", $datacontrarecibo->abonoxml);
                            $saldoxml = str_replace(",", "", $datacontrarecibo->saldoxml);

                           
                            $sentenciaabonos = $this->bd->prepare("insert into abonos_fact ( idpago,id_xml, id_prov, folio_cr,id_foliocr,abono, saldo,liquidado, fecha_crea) values (?,?,?,?,?,?,?,?,NOW());");
                            //$sentenciaabonos = $this->bd->prepare("update xml set abono=?,saldo=?, num_cr=?, fpago_cr=?,liquidado=? where id=?;");
                            $sentenciaabonos->execute([$idUltimo,$idxml,$fcontra,$foliocontra,$fcontexml,$abonoxml,$saldoxml,$liqquidado]);
                            
                            if($sentenciaabonos){

                                $sentencialiq = $this->bd->prepare("update xml set liquidado=?, pagos=? where id=?;");
                                $sentencialiq->execute([$liqquidado,'S',$idxml]);

                                $sentenciadocp = $this->bd->prepare("update odc set pago = ?,estatus=?,liquidado=? where id=?  and contrarecibo='S';");
                                $sentenciadocp->execute(['S','4',$liqquidado,$id_oc]);
                                
                                
                            }
                           

                        }
                }

        }else{
                $sentenciaabonos=false;
        }

        return $sentenciaabonos;

    }


    public  function get_trae_rutas(/*$idodc,$tipo*/)
    {
        
        //$sentencia = $this->bd->prepare("select id, id_oc, rutas, tipo_arch from rutas_arch where id_oc=? and tipo_arch=?;");
        //$sentencia->execute([$idodc,$tipo]);
        $sentencia = $this->bd->prepare("select id, id_oc, rutas, tipo_arch from rutas_arch;");
        $sentencia->execute();
        $data = [];

        while($sr = $sentencia->fetch(PDO::FETCH_ASSOC)){
            //$data[] = $sr['id_rol'];
            $data[$sr['id_oc']] = $sr;
            $data[$sr['tipo_arch']] = $sr;
            

        }
        return $data;
        
    }

   
    public  function get_trae_rutas_arch($idodc/*$idodc,$tipo*/)
    {
        
        $sentencia = $this->bd->prepare("select id, id_oc, rutas, tipo_arch from rutas_arch where id_oc=?;");
        $sentencia->execute([$idodc]);
        $datos = [];

        while($sr = $sentencia->fetch(PDO::FETCH_ASSOC)){
            //$data[] = $sr['id_rol'];
            $datos[] = $sr;
            
            

        }
        return $datos;
        
        
    }

    public  function get_tienesaldo_oc($idodc,$idUsuario)
    {
        
        $sentencia = $this->bd->prepare("select OC, iduser from odc where id=?;");
        $sentencia->execute([$idodc]);
        return $sentencia->fetch(PDO::FETCH_OBJ);
         
        
        
    }

    public  function get_tienesaldo_xml($odc,$idUsuario)
    {
        $sentencia = $this->bd->prepare("select id from xml where id_oc='".$odc."' and id_user_c='".$idUsuario."' and tipo_c='Ingreso';");
        $sentencia->execute();
        return $sentencia->fetch(PDO::FETCH_OBJ);
         
        
        
    }

    public  function get_tienesaldo_abonofac($idxml,$idUsuario)
    {
        $sentencia = $this->bd->prepare("select idpago from abonos_fact where id_xml='".$idxml."' and id_prov='".$idUsuario."';");
        $sentencia->execute();
        return $sentencia->fetch(PDO::FETCH_OBJ);
         
        
        
    }


    public  function get_abono_idpago($idpago)
    {
        /*$sentencia = $this->bd->prepare("select * from abonos_fact where idpago='".$idpago."';");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);*/

        $sentenciaexiste = $this->bd->prepare("select id FROM abonos_fact where idpago='".$idpago."' and  liquidado ='1';");
            $sentenciaexiste->execute();

            if ($sentenciaexiste->rowCount() == 0) {
                return false;
            }
         
         return true;
        
    }


   


    public  function get_finalizar_oc($idodc,$idUsuario)
    {
        
        $sentencia = $this->bd->prepare("update odc set estatus=?,user_modif=?,fecha_fin=NOW() where id=?;");
        return $sentencia->execute(['6',$idUsuario,$idodc]);
         
        
        
    }

    public  function get_cancela_oc($idodc,$idUsuario)
    {
        
        $sentencia = $this->bd->prepare("update odc set estatus=?,user_modif=?,fecha_fin=NOW() where id=?;");
        return $sentencia->execute(['7',$idUsuario,$idodc]);
         
        
        
    }


    public  function get_xml_contenido($oc,$idusuario,$tipodoc)
    {
        $tipodexml="";
        if($tipodoc=='x'){
            $tipodexml="Ingreso";
        }

        if($tipodoc=='cp'){
            $tipodexml="Pago"; 
        }

        $sentencia = $this->bd->prepare("select DISTINCT(o.iduser),x.id, x.id_arch, x.id_oc, x.UUID, x.rfc_emisor, x.emisor, x.rfc_receptor, x.receptor, x.f_emision, x.monto, x.tipo_c, x.posiscion,x.moneda from xml x left join odc o on x.id_user_c=o.iduser  where x.id_oc=$oc and o.iduser=$idusuario and tipo_c='".$tipodexml."' order by o.iduser;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public  function get_arch_contenido($id,$oc,$idusuario,$tipo)
    {
        
        $sentencia = $this->bd->prepare("select id,idorden ,id_oc,id_contr ,tipo_arch from rutas_arch where idorden=$id and id_oc=$oc and usua_crea=$idusuario and tipo_arch='".$tipo."' order by id desc;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


    public  function get_quitar_xml($idusuario,$userrol,$oc,$idxml,$posicion,$idarc)
    {
        
        $sentencia = $this->bd->prepare("delete from xml where id=? and id_oc=? and posiscion=?;");
        $sentencia->execute([$idxml,$oc,$posicion]);

        if($sentencia){
            $sentenciaar = $this->bd->prepare("delete from rutas_arch where id = ? and id_oc=?;");
            $sentenciaar->execute([$idarc,$oc]);
            
        }

        return $sentencia;
        
    }


    public  function get_quitar_arch($idusuario,$userrol,$id,$tiporch)
    {
        
        
        $sentencia = $this->bd->prepare("delete from rutas_arch where id = ? and tipo_arch=?;");
        $sentencia->execute([$id,$tiporch]);
            
        

        return $sentencia;
        
    }


     public  function get_validar_xml($uuid)
    {
        
        $sentencia = $this->bd->prepare("select UUID from xml where UUID='".$uuid."';");
        $sentencia->execute();
        return $sentencia->fetchAll();
        
    }

     public  function get_valida_xml_exista($oc,$idxml,$idusuario)
    {
        
        $sentencia = $this->bd->prepare("select UUID from xml where id_oc=? and id_user_c=?;");
        $sentencia->execute([$oc,$idusuario]);
        return $sentencia->fetchAll();
       // return $sentencia->execute([$oc,$idusuario]);
        
        
    }


     public  function get_valida_arch_exista($idusuario,$userrol,$id,$tiporch)
    {
        
        $sentencia = $this->bd->prepare("select id from rutas_arch where id=? and usua_crea=? and tipo_arch=?;");
        $sentencia->execute([$id,$idusuario,$tiporch]);
        return $sentencia->fetchAll();
       // return $sentencia->execute([$oc,$idusuario]);
        
        
    }


    public  function get_cambia_status_xml($idodc)
    {
        
        $sentencia = $this->bd->prepare("update odc set xml=?,estatus=1 where id=?;");
        return $sentencia->execute(['N',$idodc]);
         
        
        
    }

     public  function get_cambia_status_arch($idodc,$tiporch)
    {

        if($tiporch=='f'){
            $settabla="factura='N'";
        }

        if($tiporch=='e'){
            $settabla="evidencia='N'";
        }

        if($tiporch=='p'){
            $settabla="pago='N'";

            $sentenciasaldo = $this->bd->prepare("select OC from odc where id='".$idodc."';");
            $sentenciasaldo->execute();

                while($sr = $sentenciasaldo->fetch(PDO::FETCH_ASSOC)){

                         $OC=$sr['OC'];
                         
                         $sentenciaxl = $this->bd->prepare("update xml set pagos='N' where id_oc='".$OC."';");
                        return $sentenciaxl->execute();

                }
        }
        
        $sentencia = $this->bd->prepare("update odc set $settabla,estatus=1 where id='".$idodc."';");
        return $sentencia->execute();
         
        
        
    }

    public function get_traer_Proveedores_conxml()
    {
        
        
        //$sentencia = $this->bd->prepare("select u.id,u.nombre from user u left join odc o on u.id=o.iduser where u.user_role=3 and u.estatus='A' ");
        $sentencia = $this->bd->prepare("select DISTINCT(o.iduser),o.iduser,u.id,u.nombre from odc o left join user u on o.iduser=u.id left join xml x on o.iduser=x.id_user_c where u.user_role=3 and u.estatus='A' and o.factura='S' and evidencia='S' and  o.xml='S' and x.liquidado=1 GROUP by o.iduser ");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

     public  function get_xml_proveedores($id_pro)
    {
        
        $sentencia = $this->bd->prepare("select DISTINCT(o.iduser),x.id, x.id_arch, x.id_oc, x.UUID, x.rfc_emisor, x.emisor, x.rfc_receptor, x.receptor, x.f_emision, x.monto, x.tipo_c, x.posiscion,af.folio_cr,x.id_user_c,o.id as idodc,x.liquidado from xml x left join odc o on x.id_oc=o.OC left join abonos_fact af on x.id=af.id_xml  where x.id_user_c=$id_pro and x.liquidado=1 and x.tipo_c<>'pago' and o.factura='S' and evidencia='S' and  o.xml='S' order by o.iduser;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


    public  function get_dataOC($id,$od,$user)
    {
        
       
        $sentencia = $this->bd->prepare("select o.OC,o.obra,o.rfc,u.nombre from odc o left join user u on o.iduser=u.id where o.iduser=$user and o.id=$id;");
        $sentencia->execute();
        $resultados = $sentencia->fetchAll(PDO::FETCH_ASSOC);

        if (count($resultados) > 0) {
            return $resultados[0];    
        } else {
            return null;             
        }

        
    }


    public  function get_data_foliocr($id,$od,$user)
    {
        
       
        $sentencia = $this->bd->prepare("select o.OC,cx.folio_cr,DATE_FORMAT(cx.fecha_crea, '%d-%m-%Y') AS fecha_crea,cr.user_crea,u.nombre,u.correo,u.celular from odc o left join crecibo_xml cx on o.id=cx.idDoc left join crecibo cr on cx.idcr=cr.id left join user u on cr.user_crea=u.id where o.iduser=$user and o.id=$id;");
        $sentencia->execute();
        $resultados = $sentencia->fetchAll(PDO::FETCH_ASSOC);

        if (count($resultados) > 0) {
            return $resultados[0];    
        } else {
            return null;             
        }

        
    }

    public  function get_data_contrarecibo($foliocr)
    {
        
      
        $sentencia = $this->bd->prepare("select cx.id_xml,cx.id_odc,x.UUID,x.monto,x.emisor,x.receptor,DATE_FORMAT(x.fecha_crea, '%d-%m-%Y') AS fecha_crea,o.obra,o.fobra,o.OC,co.user_crea,ob.obra as obras, dp.depto as deptos FROM crecibo_xml cx left join xml x on cx.id_xml=x.id LEFT JOIN odc o on cx.idDoc=o.id left join crecibo co on cx.idcr=co.id left join cat_obras ob on o.obra=ob.id left join deptos dp on o.depto=dp.id where cx.folio_cr='".$foliocr."'");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);

    }

   

    public function get_traer_contrarecibos()
    {
        
        
        //$sentencia = $this->bd->prepare("select u.id,u.nombre from user u left join odc o on u.id=o.iduser where u.user_role=3 and u.estatus='A' ");
        $sentencia = $this->bd->prepare("select DISTINCT(o.iduser),o.iduser,u.id,u.nombre,o.rfc from odc o left join user u on o.iduser=u.id left join xml x on o.iduser=x.id_user_c where u.user_role=3 and u.estatus='A' and o.xml='S' and x.contrarecibo='S' and x.liquidado=1 GROUP by o.iduser ");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public function get_traer_pagos($iduser)
    {
        
        
        //$sentencia = $this->bd->prepare("select u.id,u.nombre from user u left join odc o on u.id=o.iduser where u.user_role=3 and u.estatus='A' ");
        $sentencia = $this->bd->prepare("select DISTINCT(p.id) as id,p.folio FROM pagos p LEFT JOIN abonos_fact ab on p.id=ab.idpago LEFT JOIN xml x on ab.id_xml=x.id where x.id_user_c='".$iduser."' and p.estatus='1' and p.contrarecibo='N' order by id asc");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


    public function get_traer_contrarecibos_id($fcontra)
    {
        
        
        //$sentencia = $this->bd->prepare("select u.id,u.nombre from user u left join odc o on u.id=o.iduser where u.user_role=3 and u.estatus='A' ");
        $sentencia = $this->bd->prepare("select DISTINCT(o.iduser),o.iduser,u.id,u.nombre,o.rfc  from odc o left join user u on o.iduser=u.id left join xml x on o.iduser=x.id_user_c where u.user_role=3 and u.estatus='A' and o.xml='S' and x.contrarecibo='S' and x.liquidado=1 and iduser=$fcontra GROUP by o.iduser ");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


     public  function get_cont_contrarecibo($fcontra)
    {
        

        $sentencia = $this->bd->prepare("select DISTINCT(cx.idcr), cx.id, cx.id_xml, cx.id_odc, cx.folio_cr, cx.user_xml, cx.idcr, cx.f_pago,c.estatus FROM crecibo_xml cx LEFT JOIN crecibo c on cx.idcr=c.id GROUP by cx.idcr;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


     public  function get_xml_contrarecibos($id_pro)
    {
        
        $sentencia = $this->bd->prepare("select x.id, x.id_arch, x.id_oc, x.UUID, x.rfc_emisor, x.emisor, x.rfc_receptor, x.receptor, x.f_emision, x.monto, x.tipo_c, x.posiscion, SUM(IF(af.abono IS NULL, 0, af.abono)) AS total_abonos, ( SELECT IF(af2.saldo IS NULL, 0, af2.saldo) FROM abonos_fact af2 WHERE af2.id_xml = x.id ORDER BY af2.id DESC LIMIT 1 ) AS ultimo_saldo,cx.idDoc FROM xml x LEFT JOIN crecibo_xml cx ON x.id = cx.id_xml LEFT JOIN abonos_fact af ON x.id = af.id_xml where cx.idcr=$id_pro and x.liquidado=1  GROUP BY x.id ORDER BY x.id DESC;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
        
    }


     public  function get_xml_pagos_rel($id_pago,$idusuario,$userrol)
    {
        
        $sentencia = $this->bd->prepare("select p.id, p.folio,ab.id_xml,ab.abono,ab.saldo,x.id_oc,o.id,o.rfc,o.fobra,o.importe FROM pagos p LEFT JOIN abonos_fact ab on p.id=ab.idpago LEFT JOIN xml x on ab.id_xml=x.id LEFT join odc o on x.id_oc=o.OC where p.id=$id_pago and x.id_user_c='".$idusuario."' and o.iduser='".$idusuario."' and o.pago='S' and p.estatus='1' and p.contrarecibo='N' order by p.id desc;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
        
    }


    public  function get_datos_cr($folio)
    {
        
       
        $sentencia = $this->bd->prepare("select cr.id,af.abono,af.saldo,af.liquidado,x.UUID,x.id_oc,cx.id_odc as idorden FROM `crecibo` cr LEFT JOIN crecibo_xml cx on cr.id=cx.idcr LEFT JOIN abonos_fact af on cx.id_xml=af.id_xml left join xml x on af.id_xml=x.id where cr.folio_cr='".$folio."';");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_ASSOC);

        
    }


    public  function trae_seguimientos($idoc)
    {
        
        $sentencia = $this->bd->prepare("select s.comentario,u.nombre FROM seguimientos s LEFT JOIN user u on s.id_user=u.id where s.id_oc='".$idoc."';");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


    public function get_comentarios_user($idUsuario,$userrol,$id_oc,$comentarios)
    { 

        
        $sentencia = $this->bd->prepare("insert into seguimientos (id_oc, id_user, comentario, leido, f_creado) values (?, ?, ?, ?,NOW());");

        $sentencia->execute([$id_oc,$idUsuario,$comentarios,'N']);

        if($sentencia){
            $sentencias = $this->bd->prepare("update odc set comentario=? where id=?;");
            $sentencias->execute(['N',$id_oc]);
            
        }

        return $sentencia;
            
    }


    public  function leer_seguimientos($idoc,$idusuario)
    {
        
        $sentencia = $this->bd->prepare("select id_user FROM seguimientos  where id_oc='".$idoc."' order by id desc limit 1;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public  function seguimientos_leido($idoc,$idusuario)
    {
        $sentencia = $this->bd->prepare("update seguimientos set leido=? where id_oc=?;");
        $sentencia->execute(['S',$idoc]);

        if($sentencia){
            $sentenciau = $this->bd->prepare("update odc set comentario=? where id=?;");
            $sentenciau->execute(['S',$idoc]);
            
        }

        return $sentencia;

        
    }


    public  function correo_usuarios($id_prov)
    {
        
        $sentencia = $this->bd->prepare("select u.correo FROM odc o LEFT JOIN user u on o.iduser=u.id where o.iduser='".$id_prov."' order by o.id desc limit 1;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public function get_trae_prove_oc()
    {
        
        
        //$sentencia = $this->bd->prepare("select id,nombre,username from user where user_role=3 and estatus='A'");
        $sentencia = $this->bd->prepare("select DISTINCT(o.rfc) rfc,u.nombre from odc o left join user u on o.iduser=u.id  where  o.estatus<>'7' order by o.rfc;");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


    public function get_trae_num_oc($idusuario,$userrol)
    {
        $usuarios='';
        if($userrol=='2' || $userrol=='1') {

            //$usuarios=" AND user_crea='".$idusuario."'";
            $usuarios="";

        }else{

            $usuarios=" AND iduser='".$idusuario."'";
            
        }

        //$sentencia = $this->bd->prepare("select id,nombre,username from user where user_role=3 and estatus='A'");
        $sentencia = $this->bd->prepare("select DISTINCT(OC) OC from odc where  estatus<>'7' $usuarios order by OC;");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


    public  function get_valida_oc($rfc_pro,$id_prov,$numnoc)
    {
        
        $sentencia = $this->bd->prepare("select id from odc where  OC='".$numnoc."' and rfc='".$rfc_pro."' and iduser='".$id_prov."';");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }    
        
    
    public function get_importe_oc($oc,$iduser,$id)
    {
        
        
        $sentencia = $this->bd->prepare("select importe from odc where OC='".$oc."' and iduser='".$iduser."'  ORDER BY id asc limit 1");
        $sentencia->execute();
        

        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    } 

    public function get_compara_uuid_xml_cp($idUsuario,$facturasRelacionadas,$pagosxml)
    { 

        foreach ($facturasRelacionadas as $uuidrelacion) {
            $idxmlrel = $uuidrelacion->idDocumento;
            $pagorel = $uuidrelacion->ImpPagado;

            $sentenciaexiste = $this->bd->prepare("select x.UUID FROM xml x left join abonos_fact ab on x.id=ab.id_xml where ab.idpago='".$pagosxml."' and x.UUID ='".$idxmlrel."' and x.monto='".$pagorel."';");
            $sentenciaexiste->execute();

            if ($sentenciaexiste->rowCount() == 0) {
                return false;
            }
                
                        
        }

        return true;

    } 

    public function get_save_archivo_xml_cp($idUsuario,$tipodoc,$files,$nombrearchi,$array_xml,$facturasRelacionadas,$datainfopagos,$pagosxml)
    { 
        
        
        foreach ($files['name'] as $key => $name) {

            $uuid = strtoupper($array_xml[$key]->complemento->UUID);
            $sentenciaexiste = $this->bd->prepare("select UUID from xml where UUID='".$uuid."';");
            $sentenciaexiste->execute();

            if ($sentenciaexiste->rowCount() > 0) {
                $existe=1;
            } else {
                $existe=2;
            }

                if ($existe==2) {

                    foreach ($datainfopagos as $keyd => $datainfop) {
                            
                            $id = $datainfop->id;
                            $odc = $datainfop->odc;
                            $rfc_pro = $datainfop->rfc;

                            
                            $base_path = "../documentos/".$id."/".$odc."/".$rfc_pro;
                            $base_path3 = "/documentos/".$id."/".$odc."/".$rfc_pro;

                            $targetFileName = basename($name); 

                            

                            $rutas_destino = [
                                $base_path."/".$nombrearchi
                            ];

                            //$targetFile = $path."/".basename($name);
                            


                            foreach ($rutas_destino as $ruta) {

                                    $targetFile = $ruta."/".$targetFileName; 
                                    
                                    if(!file_exists($ruta)){
                                       //crear directorio
                                       mkdir($ruta,0777,true);

                                       


                                    }

                                    

                                    if (move_uploaded_file($files['tmp_name'][$key], $targetFile)) {
                                            $banguardo=true;
                                            $rutaevidencia=$base_path3."/".$nombrearchi."/".basename($targetFileName);  
                                           $ruta1=$targetFile;
                                    }else{
                                        copy($ruta1, $targetFile);
                                        $rutaevidencia=$base_path3."/".$nombrearchi."/".basename($targetFileName);  
                                    }

                            
                                    

                                    

                                    


                                    $sentenciadoc = $this->bd->prepare("insert into rutas_arch (idorden,id_oc,id_contr, rutas, tipo_arch,posicion, usua_crea,fecha_pago,fecha_crea)
                                    values (?,?, ?, ?,?,?,?,?,NOW());");

                                    $sentenciadoc->execute([$id,$odc,'',$rutaevidencia,$tipodoc,$key,$idUsuario,'0000-00-00']);
                            }

                        if($sentenciadoc){


                    

                            $idUltimo=$this->bd->lastInsertId();

                            $uuid = strtoupper($array_xml[$key]->complemento->UUID);
                            $tipoComprobante = $array_xml[$key]->comprobante->TipoDeComprobante;
                            $total = $array_xml[$key]->pago->Monto;
                            $fechaEmision = $array_xml[$key]->comprobante->Fecha;
                            $emisor = $array_xml[$key]->emisor->Nombre;
                            $rfc_emisor = $array_xml[$key]->emisor->Rfc;
                            $receptor = $array_xml[$key]->receptor->Nombre;
                            $rfc_receptor = $array_xml[$key]->receptor->Rfc;
                            $monedas = $array_xml[$key]->pago->Moneda;

                                

                                
                                    

                            $sentenciaxml = $this->bd->prepare("insert into xml (id_arch, id_oc, UUID, rfc_emisor, emisor, rfc_receptor, receptor, f_emision, monto,moneda, tipo_c,posiscion, liquidado, contrarecibo,pagos,id_user_c,fecha_crea)
                                values (?, ?, ?,?,?,?, ?, ?,?,?,?,?,?,?,?,?,NOW());");

                            $sentenciaxml->execute([$idUltimo,$odc,$uuid,$rfc_emisor,$emisor,$rfc_receptor,$receptor,$fechaEmision,$total,$monedas,$tipoComprobante,$key,'1','N','N',$idUsuario]);

                                

                                    

                            
                         

                        }
                           
                            
                    }

                     
                        

                }else{
                    $sentenciadoc=false;
                }

            
        }

        if($sentenciadoc){

            foreach ($datainfopagos as $keyd => $datainfop) {
                $id = $datainfop->id;

                $sentencia = $this->bd->prepare("update odc set comppago = ?,estatus=? where id=?;");
                $sentencia->execute(['S','5',$id]);

                 $sentencia = $this->bd->prepare("update pagos set contrarecibo = ? where id=?;");
                $sentencia->execute(['S',$pagosxml]);

            }
            
        }

         return $sentenciadoc;
        
        
            
    }

    public function manda_oc_correos($id_prov)
    {
        

        $sentencia = $this->bd->prepare("select o.OC,o.ruta_oc,o.user_crea,o.fecha_crea,u.nombre,o.fobra,o.obra,o.importe,o.depto, ob.obra as obras, dp.depto as deptos,u.correo,u.celular,o.iduser,upro.nombre as nomprovee FROM odc o left join user u on o.user_crea=u.id left join cat_obras ob on o.obra=ob.id left join deptos dp on o.depto=dp.id left join user upro on o.iduser=upro.id where o.iduser='".$id_prov."' ORDER by o.id desc limit 1;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    public function actualizar_correo_proveedor($correo,$id_prov)
    {

        $sentencia = $this->bd->prepare("update user set correo = ? where id=?;");
        $sentencia->execute([$correo, $id_prov]);
    }


    public function get_ultimo_cr()
    {
        
        $sentencia = $this->bd->prepare("select id from crecibo ORDER BY id DESC limit 1;");
        $sentencia->execute();
        return $sentencia->fetch(PDO::FETCH_OBJ);
    }


    public function manda_cr_correos($id_prov,$idcr)
    {
        

        $sentencia = $this->bd->prepare("select  o.id,o.OC,cr.folio_cr,co.user_crea,u.nombre,co.f_creado FROM odc o left join crecibo_xml cr on o.id=cr.idDoc left join crecibo co on cr.idcr=co.id left join user u on co.user_crea=u.id where o.iduser='".$id_prov."' and cr.user_xml='".$id_prov."' and o.contrarecibo='S' and cr.idcr='".$idcr."' ORDER by cr.id desc limit 1;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }


    public function get_ultimo_pago()
    {
        
        $sentencia = $this->bd->prepare("select id from pagos ORDER BY id DESC limit 1;");
        $sentencia->execute();
        return $sentencia->fetch(PDO::FETCH_OBJ);
    }


    public function manda_pago_correos($id_prov,$idpago)
    {
        

        $sentencia = $this->bd->prepare("select o.id,o.OC,p.folio,p.user_crea,u.nombre,p.f_creado,pf.abono,pf.saldo FROM odc o left join crecibo_xml cr on o.id=cr.idDoc left join crecibo co on cr.idcr=co.id LEFT join abonos_fact pf on co.id=pf.id_foliocr LEFT JOIN pagos p on pf.idpago=p.id left join user u on p.user_crea=u.id where o.iduser='".$id_prov."' and cr.user_xml='".$id_prov."' and o.pago='S' and pf.idpago='".$idpago."' ORDER by cr.id desc limit 1;");
        $sentencia->execute();
        return $sentencia->fetchAll(PDO::FETCH_OBJ);
    }

    
}
