<?php

require_once '../models/InicialModel.php';
require_once '../components/pdf/reportes.php';
require_once "../components/src/PHPMailer.php";
require_once "../components/src/Exception.php";
require_once "../components/src/SMTP.php";
require_once "../components/src/templates.php";



class CargaIniController
{
    public function __construct(){
       
        $this->iniciadel = new InicialModels();
        
       $this->pdf = new Pdf_reportes();

    }


    public function traeprovee($idusuario,$userrol,$search,$num_oc,$estatusoc){

        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;

        /*if($_SESSION['userrol']=='2' || $_SESSION['userrol']=='1') { 
            $search=$search;
        }else{
                $search=$num_oc;            
        }*/


            if(empty($search)){
                 
                
                $data["datosordenes"]  = $this->get_carga_inicial($idusuario,$userrol,$search,$num_oc,$estatusoc);
                if(!$data["datosordenes"]){
                    $data["registro"]='';
                    $data["text"]="No se encontraron registros en el sistema";
                }
            }else{
                
                
                $data["datosordenes"]  = $this->get_carga_inicial($idusuario,$userrol,$search,$num_oc,$estatusoc);
                if(!$data["datosordenes"]){
                    $data["registro"]='';
                    $data["text"]="No se encontraron resultados en tu búsqueda";
                }
            }

        $objJasonproveedores = $this->iniciadel->get_traer_Proveedores();

        $numeroocs = $this->iniciadel->traer_Folios();

        //$data["datosordenes"]  = $this->get_carga_inicial($idusuario,$userrol);

        $rutas = $this->iniciadel->get_trae_rutas();
        
        $rutasarc = [];
        foreach ($data["datosordenes"] as $ordenescompra) {
             $rutasarc[] = $this->iniciadel->get_trae_rutas_arch($ordenescompra->OC);
        }

        
       $proveeOC = $this->iniciadel->get_trae_prove_oc();

       $numOC = $this->iniciadel->get_trae_num_oc($idusuario,$userrol);

        if($numeroocs){
            $numoc=$numeroocs->id+1;
        }else{
            $numoc=1;
        }

        require_once ('../vistas/proveedores.php');
        
    }

    public function nuevopro($idusuario,$userrol,$tipo_accio,$tipo_user){
        
        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;

        if($tipo_accio=='2'){ 

            $objJasonproveedores = $this->iniciadel->get_traer_Proveedores_tipo($tipo_user);
        }

        require_once ('../vistas/formuser.php');
        
    }
    
    public function nuevaordc($idusuario,$userrol,$search,$num_oc,$estatusoc){

        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;

        $objJasondeptos = $this->iniciadel->get_traer_deptos();

        $objJasonproveedores = $this->iniciadel->get_traer_Proveedores();

        $numeroocs = $this->iniciadel->traer_Folios();

        $objJasonobras = $this->iniciadel->get_traer_obras();

        $data["datosordenes"]  = $this->get_carga_inicial($idusuario,$userrol,$search,$num_oc,$estatusoc);
       
        if($numeroocs){
            $numoc=$numeroocs->id+1;
        }else{
            $numoc=1;
        }

        require_once ('../vistas/formoc.php');
        
    }

    ##va servir para filtros
    public function list($idusuario,$userrol,$estatussoli,$user_atiende,$fechaini,$fechafin){

        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;

        

        require_once ('../vistas/proveedores.php');
        
    }


    public function save_oc($idUsuario,$rfc_pro,$id_prov,$fobra,$obra,$importe,$files,$noc,$numnoc,$depto)
    { 

        $validaroc = $this->iniciadel->get_valida_oc($rfc_pro,$id_prov,$numnoc);

        if($validaroc){
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡El #OC '.$numnoc.' Ya se encuentra registrado para ese proveedor!';
            $respuesta['status']=false;
        }else{

            $guardaroc = $this->iniciadel->get_save_oc($idUsuario,$rfc_pro,$id_prov,$fobra,$obra,$importe,$files,$noc,$numnoc,$depto);

            if($guardaroc){
                $respuesta['type'] = 1;
                $respuesta['mensaje'] = '¡Se guardo el registro correctamente!';
                $respuesta['status']=true;
            }else{
                
                $respuesta['type'] = 3;
                $respuesta['mensaje'] = '¡Error al guardar el registro!';
                $respuesta['status']=false;
                
            }

        }
            

        

        return $respuesta;
        
    }

    public function get_carga_inicial($idusuario,$userrol,$search,$num_oc,$estatusoc)
    {
        $trealistado = $this->iniciadel->get_ordenes_inicial($idusuario,$userrol,$search,$num_oc,$estatusoc);

        return $trealistado;
    }


    public function cargadocumentos($idusuario,$userrol,$tipodoc,$oc,$rfc,$fobra,$id,$cadena,$montooc){

        $traecontxml='';
        $traearchivos='';

        switch ($tipodoc) {
            case 'oc':
                $archivo="Orden_compra";
                $tipoarchivo=".pdf";
                $tipocomprobante="";
                break;
            case 'f':
                $archivo="Factura";
                $tipoarchivo=".pdf";
                $tipocomprobante="";
                break;
            case 'x':
                $archivo="XML";
                $tipoarchivo=".xml";
                $tipocomprobante="I";
                break;
            case 'e':
                $archivo="Evidencia";
                $tipoarchivo=".pdf,.jpg,.jpeg,.png";
                $tipocomprobante="";
                break;
            case 'c':
                $archivo="Contra recibo";
                 $tipoarchivo=".pdf,.jpg,.jpeg";
                 $tipocomprobante="";
                break;
            case 'p':
                $archivo="Pago";
                 $tipoarchivo=".pdf,.jpg,.jpeg";
                 $tipocomprobante="";
                break;
            case 'cp':
                $archivo="Complemento_pago";
                 $tipoarchivo=".xml";
                 $tipocomprobante="";
                break;
        }


        if($cadena) {
            if($tipodoc=='x' || $tipodoc=='cp') { 
                $traecontxml = $this->iniciadel->get_xml_contenido($oc,$idusuario,$tipodoc);
            }else{
                 $traearchivos = $this->iniciadel->get_arch_contenido($id,$oc,$idusuario,$tipodoc);
            }
            
            $muestracontenido='';
        }    

        
        require_once ('../vistas/documentos.php');
        
    }


    public function save_documento($idUsuario,$rfc_pro,$fobra,$tipodoc,$odc,$files,$nombrearchi,$id,$fpgo)
    { 
        
        $guardararch = $this->iniciadel->get_save_archivos($idUsuario,$rfc_pro,$fobra,$tipodoc,$odc,$files,$nombrearchi,$id,$fpgo);

        if($guardararch['estatus']){
            $respuesta['type'] = 1;
            $respuesta['mensaje'] = '¡Se guardo el archivo correctamente!';
            $respuesta['status']=true;
            $respuesta['bandst']=$guardararch['bandestat'];
        }else{
            
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡Error al guardar el registro!';
            $respuesta['status']=false;
            $respuesta['bandst']='';
            
        }

        

        return $respuesta;
        
    }

    public function save_documento_xml($idUsuario,$rfc_pro,$fobra,$tipodoc,$odc,$files,$nombrearchi,$id,$fpgo,$array_xml,$completo,$saldoOC)
    { 
        
        $guardararch = $this->iniciadel->get_save_archivo_xml($idUsuario,$rfc_pro,$fobra,$tipodoc,$odc,$files,$nombrearchi,$id,$fpgo,$array_xml,$completo,$saldoOC);
        
        if($guardararch['estatus']){

            $respuesta['type'] = 1;
            $respuesta['mensaje'] = '¡Se guardo el archivo correctamente!';
            $respuesta['status']=true;
            $respuesta['bandst']=$guardararch['bandestat'];
        }else{
            
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡Error al guardar el registro o el xml ya se encuentra registrado!';
            $respuesta['status']=false;
            $respuesta['bandst']='';
            
        }

        

        return $respuesta;
        
    }

    public function crea_contrarecibo($idUsuario,$userrol,$arrayxml,$array_id_attr,$array_idUs_attr,$array_idDoc_attr,$fpgo)
    { 

        $guardararch = $this->iniciadel->get_crea_contrar($idUsuario,$userrol,$arrayxml,$array_id_attr,$array_idUs_attr,$array_idDoc_attr,$fpgo);

        if($guardararch){
            $respuesta['type'] = 1;
            $respuesta['mensaje'] = '¡Se guardo el registro correctamente!';
            $respuesta['status']=true;
        }else{
            
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡Error al guardar el registro!';
            $respuesta['status']=false;
            
        }

        

        return $respuesta;
        
    }


    public function crea_pago_contrarecibo($idUsuario,$userrol,$fcontra,$fcontexml,$foliocontra,$arrayabonos,$files,$rfc_user)
    { 
        //return var_dump(print_r($arrayabonos));
        $guardararch = $this->iniciadel->get_pagos_contrar($idUsuario,$userrol,$fcontra,$fcontexml,$foliocontra,$arrayabonos,$files,$rfc_user);

        if($guardararch){
            $respuesta['type'] = 1;
            $respuesta['mensaje'] = '¡Se guardo el registro correctamente!';
            $respuesta['status']=true;
        }else{
            
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡Error al guardar el registro!';
            $respuesta['status']=false;
            
        }

        

        return $respuesta;
        
    }

    public function trae_rutas($idodc,$tipo)
    {
        $trealasrutas = $this->iniciadel->get_trae_rutas($idodc,$tipo);

        return $trealasrutas;
    }


    public function finalizar_oc($idodc,$idUsuario)
    {   

        $tienesaldooc = $this->iniciadel->get_tienesaldo_oc($idodc,$idUsuario);

        $tienesaldoxml = $this->iniciadel->get_tienesaldo_xml($tienesaldooc->OC,$tienesaldooc->iduser);

        $tienesaldoabono_fac = $this->iniciadel->get_tienesaldo_abonofac($tienesaldoxml->id,$tienesaldooc->iduser);

        $tienesaldoabono_pago = $this->iniciadel->get_abono_idpago($tienesaldoabono_fac->idpago);

       if($tienesaldoabono_pago){
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡No se puede finalizar la OC, cuenta saldo pendiente!';
            $respuesta['status']=false;
        }else{
            
            $finalizaodc = $this->iniciadel->get_finalizar_oc($idodc,$idUsuario);

            if($finalizaodc){
                $respuesta['type'] = 1;
                $respuesta['mensaje'] = '¡Se finalizo correctamente el registro!';
                $respuesta['status']=true;
            }else{
                
                $respuesta['type'] = 3;
                $respuesta['mensaje'] = '¡Error al finalizar el registro!';
                $respuesta['status']=false;
                
            }
            
        }

        

        

        return $respuesta;

        
    }

    public function cancela_oc($idodc,$idUsuario)
    {
        $finalizaodc = $this->iniciadel->get_cancela_oc($idodc,$idUsuario);

        if($finalizaodc){
            $respuesta['type'] = 1;
            $respuesta['mensaje'] = '¡Se cancelo correctamente el registro!';
            $respuesta['status']=true;
        }else{
            
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡Error al cancelar el registro!';
            $respuesta['status']=false;
            
        }

        

        return $respuesta;

        
    }


    public function nuevouser($idusuario,$userrol,$tipo_accio,$tipo_user){
        
        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;
        $tipo_user='';

        

        require_once ('../vistas/formuser.php');
        
    }


    public function quitarxml($idusuario,$userrol,$oc,$idxml,$posicion,$idarc,$id)
    { 
        
        $existereg='';
        $borrarxml = $this->iniciadel->get_quitar_xml($idusuario,$userrol,$oc,$idxml,$posicion,$idarc);

        if($borrarxml){

            $existereg=$this->cambiarstatusxml($oc,$idxml,$idusuario);
            
            if($existereg['status']==false){
                $this->iniciadel->get_cambia_status_xml($id);
                
            }

            $respuesta['type'] = 1;
            $respuesta['mensaje'] = '¡Se elimino el registro!';
            $respuesta['status']=true;
        }else{
            
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡Error al eliminar el registro!';
            $respuesta['status']=false;
            
        }

        

        return $respuesta;
        
    }

   
    public function quitararch($idusuario,$userrol,$id,$tiporch,$idOC)
    { 
        
        
        $borrarxml = $this->iniciadel->get_quitar_arch($idusuario,$userrol,$id,$tiporch);

        if($borrarxml){

            $existereg=$this->cambiarstatusdoc($idusuario,$userrol,$id,$tiporch);
            
            if($existereg['status']==false){

                $this->iniciadel->get_cambia_status_arch($idOC,$tiporch);
            }

            $respuesta['type'] = 1;
            $respuesta['mensaje'] = '¡Se elimino el registro!';
            $respuesta['status']=true;
        }else{
            
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡Error al eliminar el registro!';
            $respuesta['status']=false;
            
        }

        

        return $respuesta;
        
    }

    public function validarxml($uuid)
    {
        $validaxml = $this->iniciadel->get_validar_xml($uuid);

        if($validaxml){
            
            $respuesta['status']=true;
        }else{
            
            
            $respuesta['status']=false;
            
        }

        

        return $respuesta;
    }

    public function cambiarstatusxml($oc,$idxml,$idusuario)
    {
        
        $valida_xml = $this->iniciadel->get_valida_xml_exista($oc,$idxml,$idusuario);

        if($valida_xml){
            
            $respuesta['status']=true;
        }else{
            
            
            $respuesta['status']=false;
        }
         
        return  $respuesta;
    }


    public function cambiarstatusdoc($idusuario,$userrol,$id,$tiporch)
    {
        
        $valida_arch = $this->iniciadel->get_valida_arch_exista($idusuario,$userrol,$id,$tiporch);

        if($valida_arch){
            
            $respuesta['status']=true;
        }else{
            
            
            $respuesta['status']=false;
        }
         
        return  $respuesta;
    }


    public function crearcr($idusuario,$userrol){

        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;

        $objJasonproveedores = $this->iniciadel->get_traer_Proveedores_conxml();

        

        require_once ('../vistas/formcr.php');
        
    }


    public function crearpago($idusuario,$userrol){

        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;
        $objJasoncontrareciboxml='';
        $objJasoncontrareciboc = $this->iniciadel->get_traer_contrarecibos();

        

        require_once ('../vistas/formpago.php');
        
    }


    public function crearcomppago($idusuario,$userrol){
        $traecontxml='';
        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;
        
        $objJasonpagos = $this->iniciadel->get_traer_pagos($idusuario);

        

        require_once ('../vistas/formcomppago.php');
        
    }


    public function traefacturas($id_pro){

        if($id_pro){
            $traecontxml = $this->iniciadel->get_xml_proveedores($id_pro);
        }

        

        require_once ('../vistas/formfacturasC.php');
        
    }


    public function traecontra($idusuario,$userrol,$fcontra){

        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;


        $objJasoncontrareciboc = $this->iniciadel->get_traer_contrarecibos_id($fcontra);


        $objJasoncontrareciboxml= $this->iniciadel->get_cont_contrarecibo($fcontra);


        function selected( $selected, $current = true, $echo = true ) {
            return __checked_selected_helper( $selected, $current, $echo, 'selected' );
         }
   
        function __checked_selected_helper( $helper, $current, $echo, $type ) {
                  if ( (string) $helper === (string) $current ) {
                           $result = " $type='$type'";
                  } else {
                           $result = '';
                  }
   
                  if ( $echo ) {
                           echo $result;
                  }
   
         return $result;
        }

        //require_once ('../vistas/facturaspagos.php');
        require_once ('../vistas/formpago.php');
        
    }


    public function bajar_contrarecibo($id,$od,$user){

         //$arrayDataPdf = [];

        $dataOC = $this->iniciadel->get_dataOC($id,$od,$user);

        $dataOC['imagen'] = '../images/proyectos_logo.png';

        $dataOC['folio_cr'] = $this->iniciadel->get_data_foliocr($id,$od,$user);


        $dataPdf= $this->iniciadel->get_data_contrarecibo($dataOC['folio_cr']["folio_cr"]);

        $arrayDataPdf=json_encode($dataPdf);

        

        return $this->pdf->documento_contrarecibo($dataOC,$arrayDataPdf); 

        
            
            
        
    }


    public function traefacturas_xml($id_cr){

        if($id_cr){
            $traecontxml = $this->iniciadel->get_xml_contrarecibos($id_cr);
        }

        

        require_once ('../vistas/facturaspagos.php');
        
    }


    public function traepagos_xml($id_pago,$idusuario,$userrol){

        if($id_pago){
            $traepagtxml = $this->iniciadel->get_xml_pagos_rel($id_pago,$idusuario,$userrol);
        }

        

        require_once ('../vistas/registrospagos.php');
        
    }

    public function detalles_cr($folio){

        $data = $this->iniciadel->get_datos_cr($folio);

        return $data;

    }


    public function enviarseguimiento($idoc,$idusuario,$userrol,$estatus){
        
        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;


        $data_coment = $this->iniciadel->trae_seguimientos($idoc);

        $leer_coment= $this->iniciadel->leer_seguimientos($idoc,$idusuario);

        if($leer_coment){
            $id_user = $leer_coment[0]->id_user;
            if($idusuario!==$id_user){
                $act= $this->iniciadel->seguimientos_leido($idoc,$idusuario);

            }
        }
            

        require_once ('../vistas/mandar_comentarios.php');

    }

     public function gurdar_comet_user($idUsuario,$userrol,$id_oc,$comentarios){

        $gcomentario = $this->iniciadel->get_comentarios_user($idUsuario,$userrol,$id_oc,$comentarios);

        if($gcomentario){


            $respuesta['type'] = 1;
            $respuesta['mensaje'] = '¡Se guardo el comentario!';
            $respuesta['status']=true;
        }else{
            
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡Error al eliminar el registro!';
            $respuesta['status']=false;
            
        }

        

        return $respuesta;

     }


    public function mandarcorreovendedor($id_prov,$idusuario,$userrol,$motivocorreo,$vista){
        $tipocorreo="";
        $_SESSION['idUsuario']=$idusuario;
        $_SESSION['userrol']=$userrol;

        $correo_user= $this->iniciadel->correo_usuarios($id_prov);
        
        if($correo_user){
            $us_correo = $correo_user[0]->correo;
        }else{
            $us_correo ='';
        }

        if($vista=="inicio"){
        
            if($motivocorreo=="1"){
                $tipocorreo="de alta OC";
            }

            if($motivocorreo=="2"){
                $tipocorreo="de alta contra recibo";
            }

            if($motivocorreo=="3"){
                $tipocorreo="de alta de pago";
            }

            $titulore="Reenviar correo ".$tipocorreo;
            $disabled="";
        }else{
            $titulore="";
            $disabled="disabled";
        }
        

        require_once ('../vistas/mandar_correos_pro.php');

    }



    public function importe_oc($oc,$iduser,$id)
    {
        $traemonto['monto'] = $this->iniciadel->get_importe_oc($oc,$iduser,$id);

        return $traemonto;
    }


    public function save_documento_xml_cp($idUsuario,$tipodoc,$files,$nombrearchi,$array_xml,$facturasRelacionadas,$datainfopagos,$pagosxml)
    { 
        
        $uiidxml = $this->iniciadel->get_compara_uuid_xml_cp($idUsuario,$facturasRelacionadas,$pagosxml);

        if($uiidxml){

            $guardararch = $this->iniciadel->get_save_archivo_xml_cp($idUsuario,$tipodoc,$files,$nombrearchi,$array_xml,$facturasRelacionadas,$datainfopagos,$pagosxml);
            

            if($guardararch){

                $respuesta['type'] = 1;
                $respuesta['mensaje'] = '¡Se guardo el archivo correctamente!';
                $respuesta['status']=true;
            }else{
                
                $respuesta['type'] = 3;
                $respuesta['mensaje'] = '¡Error al guardar el registro o el xml ya se encuentra registrado!';
                $respuesta['status']=false;
                
            }
        }else{
            $respuesta['type'] = 3;
            $respuesta['mensaje'] = '¡El archivo XML no corresponde al pago o los montos pagados no son iguales!';
            $respuesta['status']=false;
                
        }

        return $respuesta;
        
    }

    public function actualizar_correo($correo,$id_prov){
        $detalles_cotizaciones=$this->iniciadel->actualizar_correo_proveedor($correo,$id_prov); 
    }


    public function enviar_c_proveedor($idUsuario,$userrol,$correo,$id_prov,$motivo){

        $motivo_correo="";
        $foliocr="";
        $num_cr="";

        $num_oc=$this->iniciadel->manda_oc_correos($id_prov); 
        
        $correosArray = explode(',', $correo);

        if($motivo==1){
            $motivo_correo="Alta de Orden de compra";
        }

        if($motivo==2){
            $motivo_correo="Alta de Contra recibo";
            $foliocr=$this->iniciadel->get_ultimo_cr(); 
            $num_cr=$this->iniciadel->manda_cr_correos($id_prov,$foliocr->id); 
        }

        if($motivo==3){
            $motivo_correo="Alta de pago";
            $foliopago=$this->iniciadel->get_ultimo_pago(); 
            $num_pago=$this->iniciadel->manda_pago_correos($id_prov,$foliopago->id); 
        }
            
            $titulo_head = $motivo_correo; 
            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
            $templates = new Templates();
            $h = $templates->head($titulo_head);
            $f = $templates->footer();
            $b = $templates->body_seg_folios($num_oc);

            if($motivo==2){
                $c = $templates->body_cr_folio($num_cr);
            }else{
                $c ="";
            }

            if($motivo==3){
                $d = $templates->body_pago_folio($num_pago);
            }else{
                $d ="";
            }

            try{
                $email_soporte     = 'l.c.c-wilberth24@hotmail.com'; 
                $email_password    = 'lccwilberth12345';            
                $mail->CharSet      ="UTF-8";                 
                $mail->isSMTP();                                   
                $mail->Host         = 'smtp-mail.outlook.com';           
                $mail->SMTPAuth     = true;                        
                $mail->Username     = $email_soporte;                 
                $mail->Password     = $email_password;               
                $mail->SMTPSecure   = 'tls';
                $mail->Port         = 587; 
                          
                //de quien y donde
                $mail->setFrom($email_soporte, 'Portal');

                 foreach ($correosArray as $correos) {
                    $correos = trim($correos);  // Eliminar espacios extras
                    if (filter_var($correos, FILTER_VALIDATE_EMAIL)) {
                        $mail->addAddress($correos);  // Agregar dirección de correo válida
                    }
                }

                //$mail->addAddress($correo, $correo);
                /*if($fichaname['name']!==''){
                    $mail->AddAttachment($fichaname['tmp_name'], $fichaname['name']);
                }*/
                
                $mail->Subject = $motivo_correo;
                $mail->isHTML(true);
           
                $mail->Body = $h.$b.$c.$d.$f;

                if(!$mail->send()) {
                  $messageError = $mail->ErrorInfo;
                  $respuesta['status'] = false;
                  $respuesta['type'] = 3;
                  $respuesta['mensaje'] = $messageError;
                  return $respuesta;
                }else {

                  $datacorreo = $this->actualizar_correo($correo,$id_prov);  
                  $respuesta['status'] = true;
                  $respuesta['type'] = 1;
                  $respuesta['mensaje'] = "¡Se envió el correo al usuario exitosamente!";
                  return $respuesta;
                }

            }catch (Exception $e){
                $messageError = $mail->ErrorInfo;
                $respuesta['status'] = false;
                $respuesta['type'] = 3;
                $respuesta['mensaje'] = $messageError;
                return $respuesta;

            }

    }

}
