<?php
require_once 'plantillas_contrarecibo.php';
require_once '../vendor/autoload.php';
use \Mpdf\Mpdf;
class Pdf_reportes extends Plantillas_ContraRec{

	public function documento_contrarecibo($dataOC,$arrayData){
		
		$body_document='';
        $datos_identificacion = parent::datos_identificacion($dataOC);
        $datos_generales = parent::datos_generales($arrayData);
        
        $body_document.=$datos_identificacion.$datos_generales;
		
        return $this->encode_pdf($body_document);
	}

	public function configuration_footer(){
		$headerFooterContent = '<page_footer><span class="pie_pagina">página {PAGENO} de {nb}</span></page_footer>';
        $oddEvenConfiguration = [
            'R' => [
              'content' => $headerFooterContent,
            ],
            'line' => 0, // That's the relevant parameter
        ];
        $headerFooterConfiguration = [
          'odd' => $oddEvenConfiguration,
          'even' => $oddEvenConfiguration
        ];

        return $headerFooterConfiguration;
	}

	public function encode_pdf($body_document){
		$h = parent::header();
		$f = parent::footer();
        $body_document=$h.$body_document.$f;
		$mpdf = new Mpdf(['tempDir' =>  '../public']);
		ob_start(); 
		$mpdf->defaultfooterline = 0;
        $mpdf->setFooter($this->configuration_footer());
        $mpdf->WriteHTML($body_document);
        $mpdf->Output();
        $xlsData = ob_get_contents();
        ob_end_clean();
        $response = array(
            'status' => true,
            'name' => 'reporte.pdf',
            'file' => "data:text/plain;charset=utf-8;base64,".base64_encode($xlsData)
        );
        die(json_encode($response));
	}

	

}